/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class SerialTransactionsTest
extends AbstractClusterJModelTest {
    private static final int NUMBER_TO_INSERT = 4;

    protected int numberOfEmployees() {
        return 4;
    }

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.createSession();
        this.createEmployeeInstances(4);
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.deleteAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.createAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.findAll();
        this.createSession();
        this.updateThenVerifyAll();
        this.failOnError();
    }

    protected void createAll() {
        this.tx.begin();
        this.session.makePersistentAll((Iterable)this.employees);
        this.tx.commit();
    }

    public void findAll() {
        this.tx.begin();
        for (int i = 0; i < 4; ++i) {
            Employee employee = (Employee)this.session.find(Employee.class, (Object)i);
        }
        this.tx.commit();
    }

    public void deleteAll() {
        this.tx.begin();
        for (int i = 0; i < 4; ++i) {
            Employee employee = (Employee)this.session.find(Employee.class, (Object)i);
            this.session.deletePersistent((Object)employee);
        }
        this.tx.commit();
    }

    public void updateThenVerifyAll() {
        Employee employee;
        int n;
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            employee.setAge(4 - n);
            this.session.updatePersistent((Object)employee);
        }
        this.tx.commit();
        this.tx.begin();
        for (n = 0; n < 4; ++n) {
            int n2 = 4 - n;
            employee = (Employee)this.session.find(Employee.class, (Object)n);
            int n3 = employee.getAge();
            if (n2 == n3) continue;
            this.error("Failed update: for employee " + n + " expected age " + n2 + " actual age " + n3);
        }
        this.tx.commit();
    }
}

