/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import java.sql.Date;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.DateAsSqlDateTypes;
import testsuite.clusterj.model.IdBase;

public class QueryDateAsSqlDateTypesTest
extends AbstractQueryTest {
    public Class<DateAsSqlDateTypes> getInstanceType() {
        return DateAsSqlDateTypes.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllDateTypesInstances(n);
    }

    @Override
    protected void consistencyCheck(IdBase idBase) {
        DateAsSqlDateTypes dateAsSqlDateTypes = (DateAsSqlDateTypes)idBase;
        Date date = this.getDateFor(dateAsSqlDateTypes.getId());
        String string = "Wrong values retrieved from ";
        this.errorIfNotEqual(string + "date_not_null_hash", date, dateAsSqlDateTypes.getDate_not_null_hash());
        this.errorIfNotEqual(string + "date_not_null_btree", date, dateAsSqlDateTypes.getDate_not_null_btree());
        this.errorIfNotEqual(string + "date_not_null_both", date, dateAsSqlDateTypes.getDate_not_null_both());
        this.errorIfNotEqual(string + "date_not_null_none", date, dateAsSqlDateTypes.getDate_not_null_none());
    }

    public void test() {
        this.btreeIndexScanDate();
        this.hashIndexScanDate();
        this.bothIndexScanDate();
        this.noneIndexScanDate();
        this.failOnError();
    }

    public void btreeIndexScanDate() {
        this.equalQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(8), 8);
        this.greaterEqualQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(7), 7, 8, 9);
        this.greaterThanQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(6), 7, 8, 9);
        this.lessEqualQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), 3, 2, 1, 0);
        this.betweenQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), this.getDateFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), this.getDateFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("date_not_null_btree", "idx_date_not_null_btree", this.getDateFor(4), this.getDateFor(6), 5);
    }

    public void hashIndexScanDate() {
        this.equalQuery("date_not_null_hash", "idx_date_not_null_hash", this.getDateFor(8), 8);
        this.greaterEqualQuery("date_not_null_hash", "none", this.getDateFor(7), 7, 8, 9);
        this.greaterThanQuery("date_not_null_hash", "none", this.getDateFor(6), 7, 8, 9);
        this.lessEqualQuery("date_not_null_hash", "none", this.getDateFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("date_not_null_hash", "none", this.getDateFor(4), 3, 2, 1, 0);
        this.betweenQuery("date_not_null_hash", "none", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("date_not_null_hash", "none", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("date_not_null_hash", "none", this.getDateFor(4), this.getDateFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("date_not_null_hash", "none", this.getDateFor(4), this.getDateFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("date_not_null_hash", "none", this.getDateFor(4), this.getDateFor(6), 5);
    }

    public void bothIndexScanDate() {
        this.equalQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(8), 8);
        this.greaterEqualQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(7), 7, 8, 9);
        this.greaterThanQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(6), 7, 8, 9);
        this.lessEqualQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), 3, 2, 1, 0);
        this.betweenQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), this.getDateFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), this.getDateFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("date_not_null_both", "idx_date_not_null_both", this.getDateFor(4), this.getDateFor(6), 5);
    }

    public void noneIndexScanDate() {
        this.equalQuery("date_not_null_none", "none", this.getDateFor(8), 8);
        this.greaterEqualQuery("date_not_null_none", "none", this.getDateFor(7), 7, 8, 9);
        this.greaterThanQuery("date_not_null_none", "none", this.getDateFor(6), 7, 8, 9);
        this.lessEqualQuery("date_not_null_none", "none", this.getDateFor(4), 4, 3, 2, 1, 0);
        this.lessThanQuery("date_not_null_none", "none", this.getDateFor(4), 3, 2, 1, 0);
        this.betweenQuery("date_not_null_none", "none", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterEqualAndLessEqualQuery("date_not_null_none", "none", this.getDateFor(4), this.getDateFor(6), 4, 5, 6);
        this.greaterThanAndLessEqualQuery("date_not_null_none", "none", this.getDateFor(4), this.getDateFor(6), 5, 6);
        this.greaterEqualAndLessThanQuery("date_not_null_none", "none", this.getDateFor(4), this.getDateFor(6), 4, 5);
        this.greaterThanAndLessThanQuery("date_not_null_none", "none", this.getDateFor(4), this.getDateFor(6), 5);
    }

    private void createAllDateTypesInstances(int n) {
        for (int i = 0; i < n; ++i) {
            DateAsSqlDateTypes dateAsSqlDateTypes = (DateAsSqlDateTypes)this.session.newInstance(DateAsSqlDateTypes.class);
            dateAsSqlDateTypes.setId(i);
            dateAsSqlDateTypes.setDate_not_null_hash(this.getDateFor(i));
            dateAsSqlDateTypes.setDate_not_null_btree(this.getDateFor(i));
            dateAsSqlDateTypes.setDate_not_null_both(this.getDateFor(i));
            dateAsSqlDateTypes.setDate_not_null_none(this.getDateFor(i));
            this.instances.add(dateAsSqlDateTypes);
        }
    }

    protected Date getDateFor(int n) {
        return new Date(QueryDateAsSqlDateTypesTest.getMillisFor(1980, 0, n + 1));
    }

    public static String toString(IdBase idBase) {
        DateAsSqlDateTypes dateAsSqlDateTypes = (DateAsSqlDateTypes)idBase;
        StringBuffer stringBuffer = new StringBuffer("DateTypes id: ");
        stringBuffer.append(dateAsSqlDateTypes.getId());
        stringBuffer.append("; date_not_null_both: ");
        stringBuffer.append(dateAsSqlDateTypes.getDate_not_null_both().toString());
        stringBuffer.append("; date_not_null_btree: ");
        stringBuffer.append(dateAsSqlDateTypes.getDate_not_null_btree().toString());
        stringBuffer.append("; date_not_null_hash: ");
        stringBuffer.append(dateAsSqlDateTypes.getDate_not_null_hash().toString());
        stringBuffer.append("; date_not_null_none: ");
        stringBuffer.append(dateAsSqlDateTypes.getDate_not_null_none().toString());
        return stringBuffer.toString();
    }
}

