/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.Query;
import com.mysql.clusterj.query.QueryBuilder;
import com.mysql.clusterj.query.QueryDefinition;
import com.mysql.clusterj.query.QueryDomainType;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import testsuite.clusterj.AbstractClusterJModelTest;
import testsuite.clusterj.model.Employee;

public class AutoCommitTest
extends AbstractClusterJModelTest {
    protected static final int NUMBER_TO_INSERT = 4;

    @Override
    public void localSetUp() {
        this.createSessionFactory();
        this.session = this.sessionFactory.getSession();
        this.createEmployeeInstances(4);
        this.tx = this.session.currentTransaction();
        this.tx.begin();
        this.session.deletePersistentAll(Employee.class);
        this.tx.commit();
        this.addTearDownClasses(Employee.class);
    }

    public void test() {
        this.nontransactionalMakePersistent(0);
        this.assertTransactionNotActive("nontransactionalMakePersistent(0)");
        this.nontransactionalFind(0);
        this.assertTransactionNotActive("nontransactionalFind(0)");
        this.nontransactionalQuery(0);
        this.assertTransactionNotActive("nontransactionalQuery(0)");
        this.nontransactionalUpdate(0, 9);
        this.assertTransactionNotActive("nontransactionalUpdate(0, 9)");
        this.nontransactionalMakePersistentAll(1, 4);
        this.assertTransactionNotActive("nontransactionalMakePersistentAll(1, 4)");
        this.nontransactionalUpdateAll(1, 3, 9);
        this.assertTransactionNotActive("nontransactionalUpdateAll(1, 3, 9)");
        this.nontransactionalQuery(0, 1, 2, 3);
        this.assertTransactionNotActive("nontransactionalQuery(0, 1, 2, 3");
        this.nontransactionalDeletePersistent(2);
        this.assertTransactionNotActive("nontransactionalDeletePersistent(2)");
        this.nontransactionalQuery(0, 1, 3);
        this.assertTransactionNotActive("nontransactionalQuery(0, 1, 3)");
        this.nontransactionalDeletePersistentAll(0, 1);
        this.assertTransactionNotActive("nontransactionalDeletePersistentAll(0, 1)");
        this.nontransactionalQuery(1, 3);
        this.assertTransactionNotActive("nontransactionalQuery(1, 3)");
        this.nontransactionalDeletePersistentAll();
        this.assertTransactionNotActive("nontransactionalDeletePersistentAll()");
        this.nontransactionalQuery(new int[0]);
        this.assertTransactionNotActive("nontransactionalQuery()");
        this.failOnError();
    }

    protected void nontransactionalDeletePersistent(int n) {
        this.session.deletePersistent(this.employees.get(n));
    }

    protected void nontransactionalDeletePersistentAll() {
        this.session.deletePersistentAll(Employee.class);
    }

    protected void nontransactionalDeletePersistentAll(int n, int n2) {
        this.session.deletePersistentAll(this.employees.subList(n, n2));
    }

    protected void nontransactionalMakePersistent(int n) {
        this.session.makePersistent((Object)((Employee)this.employees.get(n)));
    }

    protected void nontransactionalMakePersistentAll(int n, int n2) {
        List list = this.employees.subList(n, n2);
        this.session.makePersistentAll(list);
    }

    protected void nontransactionalQuery(int ... nArray) {
        QueryBuilder queryBuilder = this.session.getQueryBuilder();
        QueryDomainType queryDomainType = queryBuilder.createQueryDefinition(Employee.class);
        Query query = this.session.createQuery((QueryDefinition)queryDomainType);
        List list = query.getResultList();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int n : nArray) {
            hashSet.add(n);
        }
        Object object = new HashSet();
        for (Employee employee : list) {
            object.add(employee.getId());
        }
        this.errorIfNotEqual("Mismatch in query result list", hashSet, object);
    }

    protected void nontransactionalUpdate(int n, int n2) {
        Employee employee = (Employee)this.session.find(Employee.class, (Object)n);
        employee.setAge(n2);
        this.session.updatePersistent((Object)employee);
        employee = (Employee)this.session.find(Employee.class, (Object)n);
        this.errorIfNotEqual("Mismatch in nontransactionalUpdate result age", n2, employee.getAge());
    }

    protected void nontransactionalUpdateAll(int n, int n2, int n3) {
        Employee employee;
        int n4;
        ArrayList<Employee> arrayList = new ArrayList<Employee>();
        for (n4 = n; n4 < n2; ++n4) {
            employee = (Employee)this.session.find(Employee.class, (Object)n4);
            employee.setAge(n3);
            arrayList.add(employee);
        }
        this.session.updatePersistentAll(arrayList);
        for (n4 = n; n4 < n2; ++n4) {
            employee = (Employee)this.session.find(Employee.class, (Object)n4);
            this.errorIfNotEqual("Mismatch in nontransactionalUpdateAll result age", n3, employee.getAge());
        }
    }

    private void assertTransactionNotActive(String string) {
        if (this.tx.isActive()) {
            this.error("After " + string + " the transaction was active.");
        }
    }

    private void nontransactionalFind(int n) {
        this.session.find(Employee.class, (Object)n);
    }
}

