/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.network;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.ImmutableExport;
import com.sun.electric.database.Snapshot;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.network.NetCell;
import com.sun.electric.database.network.NetSchem;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.ErrorHighlight;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public class NetworkManager {
    private final EDatabase database;
    private Snapshot lastSnapshot;
    private NetCell[] cells = new NetCell[1];
    boolean networksValid = false;
    private Cell currentErrorCell;
    private ArrayList<ErrorHighlight> errorHighlights = new ArrayList();
    private ArrayList<ErrorLogger.MessageLog> errors = new ArrayList();

    public NetworkManager(EDatabase database) {
        this.database = database;
        this.lastSnapshot = database.getInitialSnapshot();
    }

    void setCell(Cell cell, NetCell netCell) {
        assert (!NetworkTool.isLazy());
        int cellIndex = cell.getCellIndex();
        if (cellIndex >= this.cells.length) {
            int newLength;
            for (newLength = this.cells.length; cellIndex >= newLength; newLength *= 2) {
            }
            NetCell[] newCells = new NetCell[newLength];
            for (int i = 0; i < this.cells.length; ++i) {
                newCells[i] = this.cells[i];
            }
            this.cells = newCells;
        }
        this.cells[cellIndex] = netCell;
    }

    final NetCell getNetCell(Cell cell) {
        assert (!NetworkTool.isLazy());
        assert (cell.getDatabase() == this.database);
        this.database.checkExamine();
        return this.cells[cell.getCellIndex()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void redoNetworkNumbering(boolean reload) {
        assert (!NetworkTool.isLazy());
        assert (this.database.canComputeNetlist());
        long startTime = System.currentTimeMillis();
        if (reload) {
            this.lastSnapshot = this.database.getInitialSnapshot();
            this.cells = new NetCell[1];
        }
        this.advanceSnapshot();
        int ncell = 0;
        Iterator<Library> it = Library.getLibraries();
        while (it.hasNext()) {
            Library lib = it.next();
            if (lib.isHidden()) continue;
            Iterator<Cell> cit = lib.getCells();
            while (cit.hasNext()) {
                Cell cell = cit.next();
                ++ncell;
                cell.getNetlist();
            }
        }
        long endTime = System.currentTimeMillis();
        float finalTime = (float)(endTime - startTime) / 1000.0f;
        if (ncell != 0 && reload && NetworkTool.showInfo) {
            System.out.println("**** Renumber networks of " + ncell + " cells took " + finalTime + " seconds");
        }
        if (Job.isThreadSafe()) {
            this.networksValid = true;
        } else {
            Object object = NetworkTool.mutex;
            synchronized (object) {
                this.networksValid = true;
                NetworkTool.mutex.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invalidate() {
        assert (!NetworkTool.isLazy());
        assert (this.database.canComputeNetlist());
        if (Job.isThreadSafe()) {
            this.networksValid = false;
        } else if (this.networksValid) {
            Object object = NetworkTool.mutex;
            synchronized (object) {
                this.networksValid = false;
            }
        }
    }

    void advanceSnapshot() {
        assert (!NetworkTool.isLazy());
        assert (this.database.canComputeNetlist());
        Snapshot newSnapshot = this.database.backup();
        if (newSnapshot == this.lastSnapshot) {
            return;
        }
        assert (!this.networksValid);
        this.updateAll(this.lastSnapshot, newSnapshot);
        this.lastSnapshot = newSnapshot;
    }

    public void startBatch() {
        if (NetworkTool.isLazy()) {
            return;
        }
        this.invalidate();
        if (!NetworkTool.debug) {
            return;
        }
        System.out.println("NetworkTool.startBatch()");
    }

    public void endBatch() {
        if (NetworkTool.isLazy()) {
            return;
        }
        try {
            this.redoNetworkNumbering(false);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            System.err.println("Full Network renumbering after crash.");
            e.printStackTrace(System.out);
            System.out.println("Full Network renumbering after crash.");
            this.redoNetworkNumbering(true);
        }
        if (!NetworkTool.debug) {
            return;
        }
        System.out.println("NetworkTool.endBatch()");
    }

    private void updateAll(Snapshot oldSnapshot, Snapshot newSnapshot) {
        Cell cell;
        CellId cellId;
        CellRevision newRevision;
        CellRevision oldRevision;
        int i;
        assert (!NetworkTool.isLazy());
        this.invalidate();
        int maxCells = Math.max(oldSnapshot.cellBackups.size(), newSnapshot.cellBackups.size());
        if (this.cells.length < maxCells) {
            NetCell[] newCells = new NetCell[Math.max(this.cells.length * 2, maxCells)];
            System.arraycopy(this.cells, 0, newCells, 0, this.cells.length);
            this.cells = newCells;
        }
        for (i = 0; i < maxCells; ++i) {
            CellBackup oldBackup = oldSnapshot.getCell(i);
            CellBackup newBackup = newSnapshot.getCell(i);
            if (newBackup != null || oldBackup == null) continue;
            this.cells[i] = null;
        }
        for (i = 0; i < maxCells; ++i) {
            oldRevision = oldSnapshot.getCellRevision(i);
            newRevision = newSnapshot.getCellRevision(i);
            if (newRevision == null || oldRevision != null) continue;
            cellId = newRevision.d.cellId;
            cell = this.database.getCell(cellId);
            if (cell.isIcon() || cell.isSchematic()) {
                new NetSchem(cell);
                continue;
            }
            new NetCell(cell);
        }
        for (i = 0; i < maxCells; ++i) {
            oldRevision = oldSnapshot.getCellRevision(i);
            newRevision = newSnapshot.getCellRevision(i);
            if (newRevision == null || oldRevision == null) continue;
            cellId = newRevision.d.cellId;
            cell = this.database.getCell(cellId);
            NetCell netCell = this.getNetCell(cell);
            if (netCell.cell == cell) continue;
            if (cell.isIcon() || cell.isSchematic()) {
                new NetSchem(cell);
                continue;
            }
            new NetCell(cell);
        }
        if (oldSnapshot.cellGroups != newSnapshot.cellGroups) {
            int oldGroupIndex;
            int newGroupIndex;
            int maxOldGroupIndex = -1;
            for (int oldGroupIndex2 : oldSnapshot.cellGroups) {
                maxOldGroupIndex = Math.max(maxOldGroupIndex, oldGroupIndex2);
            }
            int[] oldGroupMap = new int[maxOldGroupIndex + 1];
            Arrays.fill(oldGroupMap, -2);
            for (int cellIndex = 0; cellIndex < oldSnapshot.cellGroups.length; ++cellIndex) {
                int newGroupIndex2;
                int oldGroupIndex3 = oldSnapshot.cellGroups[cellIndex];
                if (oldGroupIndex3 < 0) continue;
                int n = newGroupIndex2 = cellIndex < newSnapshot.cellGroups.length ? newSnapshot.cellGroups[cellIndex] : -1;
                if (oldGroupMap[oldGroupIndex3] == -2) {
                    oldGroupMap[oldGroupIndex3] = newGroupIndex2;
                    continue;
                }
                if (oldGroupMap[oldGroupIndex3] == newGroupIndex2) continue;
                oldGroupMap[oldGroupIndex3] = -3;
            }
            for (int oldGroupIndex4 : oldGroupMap) {
                assert (oldGroupIndex4 != -2);
            }
            int maxNewGroupIndex = -1;
            for (int newGroupIndex3 : newSnapshot.cellGroups) {
                maxNewGroupIndex = Math.max(maxNewGroupIndex, newGroupIndex3);
            }
            int[] newGroupMap = new int[maxNewGroupIndex + 1];
            Arrays.fill(newGroupMap, -2);
            for (int cellIndex = 0; cellIndex < newSnapshot.cellGroups.length; ++cellIndex) {
                newGroupIndex = newSnapshot.cellGroups[cellIndex];
                if (newGroupIndex < 0) continue;
                int n = oldGroupIndex = cellIndex < oldSnapshot.cellGroups.length ? oldSnapshot.cellGroups[cellIndex] : -1;
                if (newGroupMap[newGroupIndex] == -2) {
                    newGroupMap[newGroupIndex] = oldGroupIndex;
                    continue;
                }
                if (newGroupMap[newGroupIndex] == oldGroupIndex) continue;
                newGroupMap[newGroupIndex] = -3;
            }
            for (int newGroupIndex4 : newGroupMap) {
                assert (newGroupIndex4 != -2);
            }
            for (int cellIndex = 0; cellIndex < newSnapshot.cellGroups.length; ++cellIndex) {
                newGroupIndex = newSnapshot.cellGroups[cellIndex];
                if (newGroupIndex == -1 || (oldGroupIndex = newGroupMap[newGroupIndex]) == -1 || oldGroupIndex >= 0 && oldGroupMap[oldGroupIndex] == newGroupIndex) continue;
                CellId cellId2 = newSnapshot.getCellRevision((int)cellIndex).d.cellId;
                Cell cell2 = this.database.getCell(cellId2);
                NetSchem.updateCellGroup(cell2.getCellGroup());
                newGroupMap[newGroupIndex] = -1;
            }
        }
        for (i = 0; i < maxCells; ++i) {
            boolean exportsChanged;
            oldRevision = oldSnapshot.getCellRevision(i);
            CellRevision newRevision2 = newSnapshot.getCellRevision(i);
            if (newRevision2 == null || oldRevision == null || oldRevision == newRevision2) continue;
            cellId = newRevision2.d.cellId;
            Cell cell3 = this.database.getCell(cellId);
            boolean bl = exportsChanged = !newRevision2.sameExports(oldRevision);
            if (!exportsChanged) {
                for (int j = 0; j < newRevision2.exports.size(); ++j) {
                    if (((ImmutableExport)newRevision2.exports.get((int)j)).name == ((ImmutableExport)oldRevision.exports.get((int)j)).name) continue;
                    exportsChanged = true;
                }
            }
            NetCell netCell = this.getNetCell(cell3);
            if (exportsChanged) {
                netCell.exportsChanged();
                continue;
            }
            netCell.setNetworksDirty();
        }
    }

    void startErrorLogging(Cell cell) {
        this.currentErrorCell = cell;
        this.errorHighlights.clear();
        this.errors.clear();
    }

    void pushHighlight(Export e) {
        this.errorHighlights.add(ErrorHighlight.newInstance(e));
    }

    void pushHighlight(Geometric geom) {
        assert (geom.getParent() == this.currentErrorCell);
        this.errorHighlights.add(ErrorHighlight.newInstance(null, geom));
    }

    void pushHighlight(PortInst pi) {
        Poly poly = pi.getPoly();
        Point2D[] points = poly.getPoints();
        for (int i = 0; i < points.length; ++i) {
            int prev = i - 1;
            if (i == 0) {
                prev = points.length - 1;
            }
            this.errorHighlights.add(ErrorHighlight.newInstance(this.currentErrorCell, points[prev], points[i]));
        }
    }

    void logError(String message, int sortKey) {
        this.errors.add(new ErrorLogger.MessageLog(message, this.currentErrorCell, sortKey, this.errorHighlights));
        this.errorHighlights.clear();
    }

    void logWarning(String message, int sortKey) {
        this.errors.add(new ErrorLogger.WarningLog(message, this.currentErrorCell, sortKey, this.errorHighlights));
        this.errorHighlights.clear();
    }

    void finishErrorLogging() {
        Job.updateNetworkErrors(this.currentErrorCell, this.errors);
        this.errorHighlights.clear();
        NetworkTool.totalNumErrors += this.errors.size();
        this.errors.clear();
    }
}

